/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api.reflection.access;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.skinsrestorer.api.reflection.access.DefaultImpl;
import net.skinsrestorer.api.reflection.reflect.DuckReflect;

public class ReflectImpl
extends DefaultImpl {
    private final boolean _canUnsafeAccess;
    private boolean _canGetValue = true;
    private boolean _canSetValue = true;
    private boolean _canGetNewInstance = false;
    private boolean _useDefaultAccess = true;
    private boolean _classesExist = false;
    private boolean _newInstancesExist = false;
    private boolean _methodsExist = false;
    private boolean _lazy;
    private Class<?> _reflectionFactory = null;
    private Class<?> _fieldAccessor = null;
    private Object _factory = null;
    private Method _newFieldAccessor = null;
    private Method _set = null;
    private Method _get = null;
    private Method _acquireConstructorAccessor = null;
    private Method _newConstructorAccessor = null;
    private Method _newInstance = null;
    private Field _constructorAccessor = null;

    public ReflectImpl(DuckReflect reflect, boolean canSetModifiers, boolean canGetNewInstance, boolean useDefaultAccess, boolean canUnsafeAccess, boolean lazy) {
        super(reflect, canSetModifiers);
        this._lazy = canGetNewInstance & lazy;
        this._canUnsafeAccess = canUnsafeAccess;
        if (!useDefaultAccess) {
            this.useDefaultAccess(false);
        }
        if (canGetNewInstance & !this._lazy) {
            this.changeGetNewInstance(true);
        }
    }

    public ReflectImpl(DuckReflect reflect, boolean canSetModifiers, boolean canGetNewInstance, boolean useDefaultAccess, boolean canUnsafeAccess) {
        this(reflect, canSetModifiers, canGetNewInstance, useDefaultAccess, canUnsafeAccess, true);
    }

    private void setClasses() {
        this._reflectionFactory = this._reflect.getClass("sun.reflect.ReflectionFactory");
        this._fieldAccessor = this._reflect.getClass("sun.reflect.FieldAccessor");
        this._classesExist = this._reflectionFactory != null & this._fieldAccessor != null;
    }

    private void setNewInstances() {
        if (!this._classesExist) {
            this.setClasses();
        }
        if (this._classesExist) {
            this._newFieldAccessor = this._reflect.getMethod(this._reflectionFactory, "newFieldAccessor", Field.class, Boolean.TYPE);
            this._factory = this._reflect.call(this._reflectionFactory, "getReflectionFactory");
            this._newInstancesExist = this._newFieldAccessor != null && this._factory != null;
        }
    }

    private void setMethods() {
        if (!this._newInstancesExist) {
            this.setNewInstances();
        }
        if (this._newInstancesExist) {
            this._get = this._reflect.getMethod(this._fieldAccessor, "get", Object.class);
            this._set = this._reflect.getMethod(this._fieldAccessor, "set", Object.class, Object.class);
            this._methodsExist = this._get != null & this._set != null;
        }
    }

    @Override
    public Object getValue(Field target, Object obj) {
        if (!this._canGetValue) {
            return null;
        }
        if (this._useDefaultAccess) {
            return super.getValue(target, obj);
        }
        Object fieldAccessor = this._reflect.call(this._newFieldAccessor, this._factory, target, this._canUnsafeAccess);
        return this._reflect.call(this._get, fieldAccessor, obj);
    }

    @Override
    public boolean setValue(Field target, Object obj, Object value) {
        if (!this._canSetValue) {
            return false;
        }
        if (this._useDefaultAccess) {
            return super.setValue(target, obj, value);
        }
        Object fieldAccessor = this._reflect.call(this._newFieldAccessor, this._factory, target, this._canUnsafeAccess);
        return this._reflect.exec(this._set, fieldAccessor, obj, value);
    }

    private Object getConstructorAccessor(Constructor<?> target) {
        Object accessor;
        if (this._constructorAccessor != null && (accessor = this._reflect.getValue(this._constructorAccessor, target)) != null) {
            return accessor;
        }
        this._reflect.reset();
        if (this._acquireConstructorAccessor != null && (accessor = this._reflect.call(this._acquireConstructorAccessor, target, new Object[0])) != null) {
            return accessor;
        }
        this._reflect.reset();
        return this._reflect.call(this._newConstructorAccessor, this._factory, target);
    }

    @Override
    public Object getNewInstance(Constructor<?> target, Object ... args) {
        Object accessor;
        if (!this._canGetNewInstance) {
            if (this._lazy) {
                this.changeGetNewInstance(true);
                this._lazy = false;
                this._reflect.reset();
            } else {
                return null;
            }
        }
        if (this._newInstance == null & (accessor = this.getConstructorAccessor(target)) != null) {
            this._newInstance = this._reflect.getMethod(accessor.getClass(), "newInstance", Object[].class);
        }
        return this._reflect.call(this._newInstance, accessor, new Object[]{args});
    }

    @Override
    public boolean changeGetValue(boolean enable) {
        this._canGetValue = enable;
        return true;
    }

    @Override
    public boolean changeSetValue(boolean enable) {
        this._canSetValue = enable;
        return true;
    }

    @Override
    public boolean changeGetNewInstance(boolean enable) {
        if (enable) {
            if (this._constructorAccessor == null & this._acquireConstructorAccessor == null & this._newConstructorAccessor == null & this._newInstance == null) {
                this._constructorAccessor = this._reflect.getField(Constructor.class, "constructorAccessor");
                this._acquireConstructorAccessor = this._reflect.getMethod(Constructor.class, "acquireConstructorAccessor", new Class[0]);
                this._newConstructorAccessor = this._reflect.getMethod(this._reflectionFactory, "newConstructorAccessor", Constructor.class);
                this._newInstance = this._reflect.getMethod(this._reflect.getClass("sun.reflect.ConstructorAccessor"), "newInstance", Object[].class);
            }
            this._canGetNewInstance = this._constructorAccessor != null | this._acquireConstructorAccessor != null | this._newConstructorAccessor != null;
            return this._canGetNewInstance;
        }
        this._canGetNewInstance = true;
        return true;
    }

    public boolean useDefaultAccess(boolean enable) {
        if (!enable) {
            if (!this._methodsExist) {
                this.setMethods();
            }
            this._useDefaultAccess = !this._methodsExist;
            return this._methodsExist;
        }
        this._useDefaultAccess = true;
        return true;
    }
}

